var moment = require('moment');
var fits = require('./lib-fits');

var crlf = "\r\n";

class Add {
    constructor(invno, text) {
        var obj = parseAdd(text);
        this.invno = invno;
        this.invdate = obj.invdate;
        this.time = obj.time;
        this.checkno = obj.checkno;
        this.bno = obj.bno;
        this.carrier = obj.carrier;
        this.love = obj.love;
        this.random = obj.random;
        this.pretax = obj.pretax;
        this.calc = obj.calc;
        this.invamt = obj.invamt;
        this.paytype = obj.paytype;
        this.carriertype = obj.carriertype;
        this.special_acct_name = obj.special_acct_name;
        this.nt = obj.nt;
        // this.weekday = obj.weekday;
        this.items = obj.items;
        this.tax = obj.tax; // 發票稅額 
        this.tex = obj.tex; // 應稅發票總銷售額(未稅)
        this.oex = obj.oex; // 免稅發票總銷售額
        this.month = obj.invdate.substring(4, 6);
    }
}


class Void {
    constructor(invno, text) {
        var obj = parseVoid(text);
        this.invno = invno;
        this.invdate = obj.invdate;
        this.date = obj.date;
        this.time = obj.time;
        this.bno = obj.bno;
        // this.weekdate = obj.weekday;
        this.month = obj.invdate.substring(4, 6);
    }
}


class Unvoid {
    constructor(text) {
        var obj = parseUnvoid(text);
        this.invno = obj.invno;
        this.invdate = obj.invdate;
        this.date = obj.date;
        this.time = obj.time;
        this.type = obj.type;
        this.bno = obj.bno;
        this.posid = obj.posid;
        // this.weekdate = obj.weekday;
        this.month = obj.invdate.substring(4, 6);
    }
}

class InvTerm {
    constructor(markserialinterval) { //markserialinterval : 關貿取得發票批次

        var res = markserialinterval;
        var meta = res.resultdata;
        var obj = mergeTerm(meta); //關貿不能指定取1批，只可指定張數，取得發票批次，例，取500張，如果雲端匯入100張/批，則會下來5批 ==> 自行合併成1批
        var period = obj.period;
        this.invnob = obj.nums;
        this.invnoe = obj.nume;
        this.event_id = res.event_id;
        // console.log("period", period);
        this.year = Number(period.substring(0, 4)) - 1911;
        this.month = formatMonth(period.substring(4, 6));

    }
}


module.exports = {
    Add: Add,
    Void: Void,
    Unvoid: Unvoid,
    InvTerm: InvTerm
}

// ===========================================================================

function parseAdd(text) {
    // 1.全應稅："pretax":"284","calc":"0","invamt":"284","nt":"0"
    // {"invno":"GE05100037","invdate":"20221127","time":"17:19:58","checkno":"221127-025","bno":"","carrier":"","love":"111","random":"1845",
    // "pretax":"284","calc":"0","invamt":"284","paytype":"1","carriertype":"","special_acct_name":"","nt":"0","weekday":0,
    // "items":[{"itemname":"旗艦海陸沙拉GG(1)","qty":"1","price":"258","amt":"258"},{"itemname":"服務費","qty":"1","price":"26","amt":"26"}]}

    // 2.全免稅
    // {"invno":"GE05100041","invdate":"20221127","time":"18:19:43","checkno":"221127-029","bno":"","carrier":"","love":"","random":"4621",
    // "pretax":"50","calc":"0","invamt":"50","paytype":"1","carriertype":"","special_acct_name":"","nt":"50","weekday":0,
    // "items":[{"itemname":"黃金脆薯","qty":"1","price":"50","amt":"50"}],"tax":3,"tex":47}

    // 2.混合(有品項免稅$50):"pretax":"115","calc":"0","invamt":"165","nt":"50"
    // {"invno":"GE05100038","invdate":"20221127","time":"17:42:47","checkno":"221127-026","bno":"","carrier":"","love":"","random":"2540",
    // "pretax":"115","calc":"0","invamt":"165","paytype":"1","carriertype":"","special_acct_name":"","nt":"50","weekday":0,
    // "items":[{"itemname":"黃金脆薯","qty":"1","price":"50","amt":"50"},{"itemname":"歡樂炸物拼盤","qty":"1","price":"100","amt":"100"},{"itemname":"服務費","qty":"1","price":"15","amt":"15"}]}

    var data = text.split(crlf);
    var output = {};

    for (let i = 0; i < data.length; i++) {
        var element = data[i];
        if (i == 0) { //第一行:主檔
            if (element == "") { break; }
            var cols = element.split(",");
            if (cols.length >= 14) {
                var item = {};
                output.invdate = fits.replace(cols[0], "/", "");
                // output.weekday = weekday(cols[0]);
                output.time = cols[1];
                output.checkno = cols[2];
                output.bno = cols[3];
                output.carrier = cols[4];
                output.love = cols[5];
                output.random = cols[6];
                output.pretax = cols[7];
                output.calc = cols[8]; //免稅金額 =發票金額 invamt - pretax  |  免稅金額 =發票金額 (混合) invamt - pretax - nt
                output.invamt = cols[9];
                output.paytype = cols[10];
                output.carriertype = cols[11];
                output.special_acct_name = cols[12];
                output.nt = cols[13];

                if (output.nt == output.invamt) { // 免稅
                    output.tax = 0;
                    output.tex = 0;
                    output.oex = output.nt;
                } else {
                    output.tax = Math.round(Number(output.pretax) * 0.05);
                    output.tex = Number(output.pretax) - output.tax;
                    output.oex = output.nt;
                }

                // texclusiveAmount	應稅發票總銷售額(未稅)
                // oexclusiveAmount	免稅發票總銷售額
                // zexclusiveAmount	零稅率發票總銷售額
                // tax	發票稅額

            }
            output.items = [];
        } else { // 第2行起:明細
            if (element == "") { break; }

            var cols = element.split(":");
            if (cols.length >= 5) {
                var item = {};
                item.itemname = cols[0];
                item.qty = cols[1];
                item.price = cols[2];
                item.nt = cols[3].trim();
                item.amt = cols[4];
                output.items.push(item);
            }
        }
    }


    if (output.items.length == 0) {
        var item = {};
        item.itemname = "餐飲費";
        item.qty = 1;
        item.price = output.invamt;
        item.nt = "";
        item.amt = output.invamt;
        output.items.push(item);

        //如果沒有傳明細，則全列應稅;
        output.pretax = output.invamt;
        output.nt = 0;
        output.tax = Math.round(Number(output.pretax) * 0.05);
        output.tex = Number(output.pretax) - output.tax;
        output.oex = output.nt;
    }

    console.log("inve", JSON.stringify(output));

    return output;

}



function parseVoid(text) {
    var data = text.split(crlf);
    var output = {};

    if (data.length > 0) {
        var element = data[0];
        var cols = element.split(",");
        if (cols.length >= 4) {
            output.invdate = fits.replace(cols[0], "/", "");
            output.date = fits.replace(cols[1], "/", "");
            output.time = cols[2];
            output.bno = cols[3];
            // output.weekday = weekday(cols[1]);
        }
    }

    return output;
}


function parseUnvoid(text) {
    var data = text.split(crlf);
    var output = {};

    // GE05100017, 2022 / 11 / 27, , 2022 / 11 / 27, 01: 24: 35, 操作錯誤

    if (data.length > 0) {
        var element = data[0];
        var cols = element.split(",");
        if (cols.length >= 6) {
            output.invno = cols[0];
            output.invdate = fits.replace(cols[1], "/", "");
            output.date = fits.replace(cols[3], "/", "");
            output.time = cols[4];
            output.type = cols[5];
            // output.posid = cols[6];
            // output.weekday = weekday(cols[1]);
        }
    }

    return output;
}



// function fmtDate(value) {
//     value = value.toString().trim();
//     value = value.replace(/\//g, "");
//     return value;
// }

// function weekday(value) {
//     value = fmtDate(value);
//     var date = moment(value);
//     return date.weekday();
// }

function formatMonth(month) {
    month = Number(month);
    if (month <= 2) {
        return "01-02"
    } else if (month <= 4) {
        return "03-04"
    } else if (month <= 6) {
        return "05-06"
    } else if (month <= 8) {
        return "07-08"
    } else if (month <= 10) {
        return "09-10"
    } else if (month <= 12) {
        return "11-12"
    }
    return month;
}



function mergeTerm(terms) {
    try {
        if (terms.length == 1) {
            return terms[0];
        }

        var output = {};

        fits.writeLog("合併前批號集合", JSON.stringify(terms));
        for (let i = 0; i < terms.length; i++) {
            var row = terms[i];

            if (output.period == undefined) { output.period = row.period; }
            if (output.nums == undefined) { output.nums = row.nums; }
            if (output.nume == undefined) {
                output.nume = row.nume;
            } else {
                var nextNo = addInvNo(output.nume);
                if (nextNo == row.nums) { //如果上一筆批號的未碼+1 == 這筆的起始碼 =>合併批號
                    output.nume = row.nume;
                    fits.writeLog("合併下一批", JSON.stringify(row));
                }
            }
        }
        fits.writeLog("合併完批次", JSON.stringify(row));
        return output;
    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}

function addInvNo(invno, count = 1) {
    try {
        var str = invno.substring(0, 2);
        var num = fits.val(invno.substring(2));
        num += count;
        num = fits.zeroFill(8, num);
        return str + num;
    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}