var fs = require('fs');
var INI = require('ini');
var ini = INI.parse(fs.readFileSync('./app.ini', 'utf-8'));
var bk35 = require('./lib-adodb.js');
var TE = require('./class-Tradeven');
var api = require('./api-Tradeven.js');
const { v4: uuidv4 } = require('uuid');
var moment = require("moment");
var fits = require('./lib-fits');

var companyUn = ini.companyUn;
var orgId = ini.orgId;
var orgUn = ini.orgUn;
var privateKey = ini.PrivateKey;
var publicKey = ini.PublicKey;
var acnt = ini.acnt;
var acntp = ini.acntp;
var numRange = ini.numRange;
if (numRange == undefined) { numRange = 250; }
numRange = Math.floor(numRange / 50) * 50;


module.exports = {

    add(inve) { // 將上傳的"開立"發票資料轉成關貿api格式

        var obj = new TE.IssueData("G")
        obj.companyUn = companyUn; // 公司統一編號 String 8 V
        obj.orgId = orgId; // 事業別代碼 String 5 V
        obj.orgUn = orgUn; // 事業別統一編號 String 8 V
        obj.type = "G"; // 類別 String 1 V    I:開立發票      R:重開發票
        obj.saleIdentifier = companyUn + inve.checkno + inve.invno; // 銷售單識別碼 String 100 V
        obj.transactionNumber = inve.checkno; // 銷售單交易編號 String 50 V
        obj.transactionDate = inve.invdate; // 銷售單交易日期 String 8 V
        obj.transactionTime = inve.time; // 銷售單交易時間 String 8 V
        obj.invoiceNumber = inve.invno; // 發票號碼 String 10 V
        obj.checkNumber = inve.random; // 隨機碼 String 4 V
        obj.invoiceDate = inve.invdate; // 發票日期 String 8 V
        obj.invoiceTime = inve.time; //發票時間 String 8 V
        // obj.texclusiveAmount = Number(inve.tex) + Number(inve.calc); //應稅發票總銷售額(未稅) String 20 V
        obj.texclusiveAmount = inve.pretax; //應稅發票總銷售額(未稅) String 20 V
        obj.oexclusiveAmount = inve.oex; //免稅發票總銷售額 String 20 V
        obj.zexclusiveAmount = "0"; // 零稅率發票總銷售額 String 20 V
        obj.tax = inve.tax; // 發票稅額 String 20 V
        obj.total = inve.invamt; //銷售總金額 / 折讓總金額 / 發票總金額 String 20 V
        obj.donate = isDonate(inve.love); // 發票是否捐贈 String 1 V
        obj.donationUnit = inve.love; // 	發票捐贈單位	String	10
        // // if (getCarrierType(inve.carrier) != "") {
        obj.carrierType = getCarrierType(inve.carrier); // 	發票載具類型	String	6
        obj.carrierId = inve.carrier; // 	發票載具編號顯碼	String	64
        obj.carrierIdHidden = inve.carrier; // 	發票載具編號隱碼	String	64
        // // }
        obj.buyerUn = inve.bno; // 統一編號	String	8
        obj.invoiceType = "07" //若Type為「I」、「R」、「G」則必填	"07：一般稅額計算之電子發票        
        obj.paperPrintMode = getPaperPrintMode(inve); // 消費者發票或折讓列印之方式 String 1 V 0：不索取紙本(電子發票)  1：前端已列印，ex: POS
        obj.invoiceAlarmMode = "0"; //發票或折讓之通知方式 String 1 V
        obj.itemList = [] // 發票明細項目(Item List of eGUI) List < IssueItem > V


        var index = 0;
        inve.items.forEach(element => {
            index++;
            var list = new TE.ItemList;
            list.saleIdentifier = companyUn + inve.checkno + inve.invno; // 銷售單識別碼	String	100	V	V	必填	"當IssueData的type=I、G、R時，同IssueData saleIdentifier 當IssueData的type=A、H時，欲折讓之發票銷售單識別碼"
            list.serialNumber = index; // 	銷售項目序號/折讓項目序號	String	4	V	V	必填	"0001,0002,0003…    若Type為「A 」、「H」，需列出對應銷售項目序號"
            list.productCode = ""; // 收費代碼;產品編碼	String	30	V	V		
            list.productName = element.itemname; // 銷售品項/折讓品項	String	300	V	V	必填	
            list.qty = element.qty; // 	銷售數量/折讓數量	String	20	V	V	必填	
            list.price = element.price; // 單價(含稅)	String	20	V	V	必填	
            list.itemTotal = element.amt; // 	品項含稅銷售額/品項含稅折讓額	String	20	V	V	必填	
            list.taxType = getTaxType(element.nt); // 銷稅稅別	String	1	V	V	必填	"T：應稅    O：免稅    Z：零稅率"
            obj.itemList.push(list);
        });


        fits.writeLog("加密前的資料", JSON.stringify(obj));
        var encrypted = api.encrypt(JSON.stringify(obj), privateKey).update;

        var obj1 = {};
        obj1.acnt = acnt;
        obj1.acntp = acntp;
        obj1.issueData = encrypted;

        // console.log("step 3 公鑰加密:");
        var encrypted = api.encrypt(JSON.stringify(obj1), publicKey).update;
        var output = {};
        output.v = encrypted;
        return output;
    },


    async void(inve) { // 將上傳的"作廢"發票資料轉成關貿api格式

        var checkno = await bk35.getCheckNo(inve.invno);
        console.log("checkno", checkno);

        var obj = new TE.VoidData();
        obj.type = "I"; //	作業類別	String	1	必填，內容需符合說明	"C： 發票註銷 I： 發票作廢 A： 折讓作廢 "
        // obj.companyUn = "12967293" // 總公司統編 String 8 若Type為「 A」 時必填
        obj.saleIdentifier = companyUn + checkno + inve.invno; // 銷售單識別碼 String 100 若Type為「 C」 或「 I」 則此欄位必填
        obj.invoiceNumber = inve.invno; // 發票號碼 String 10 若Type為「 C」 或「 I」 則此欄位必填
        obj.invoicePaperReturned = "Y"; // 發票紙本是否已收回 String 1 若Type為「 C」 或「 I」 且該發票為個人戶則此欄位必填 Y是 / N否

        fits.writeLog("加密前的資料", JSON.stringify(obj));
        var encrypted = api.encrypt(JSON.stringify(obj), privateKey).update;

        var obj1 = {};
        obj1.acnt = acnt;
        obj1.acntp = acntp;
        obj1.voidData = encrypted;

        // console.log("step 3 公鑰加密:",publicKey);
        var encrypted = api.encrypt(JSON.stringify(obj1), publicKey).update;
        var output = {};
        output.v = encrypted;
        return output;
    },

    async void_c(inve) {

        var checkno = await bk35.getCheckNo(inve.invno);
        console.log("checkno", checkno);

        var obj = new TE.VoidData();
        obj.type = "C"; //	作業類別	String	1	必填，內容需符合說明	"C： 發票註銷 I： 發票作廢 A： 折讓作廢 "
        // obj.companyUn = "12967293" // 總公司統編 String 8 若Type為「 A」 時必填
        obj.saleIdentifier = companyUn + checkno + inve.invno; // 銷售單識別碼 String 100 若Type為「 C」 或「 I」 則此欄位必填
        obj.invoiceNumber = inve.invno; // 發票號碼 String 10 若Type為「 C」 或「 I」 則此欄位必填
        obj.invoicePaperReturned = "Y"; // 發票紙本是否已收回 String 1 若Type為「 C」 或「 I」 且該發票為個人戶則此欄位必填 Y是 / N否
        // obj.InvoiceCancelTime = inve.time;

        fits.writeLog("加密前的資料", JSON.stringify(obj));
        var encrypted = api.encrypt(JSON.stringify(obj), privateKey).update;

        var obj1 = {};
        obj1.acnt = acnt;
        obj1.acntp = acntp;
        obj1.voidData = encrypted;

        // console.log("step 3 公鑰加密:", publicKey);
        var encrypted = api.encrypt(JSON.stringify(obj1), publicKey).update;
        var output = {};
        output.v = encrypted;
        return output;
    },


    async add_r(inve) {

        var invoice = await bk35.getInvoice(inve.invno);
        var checkno = invoice.CheckNo;
        var invamt = invoice.InvAmt;
        console.log("checkno", checkno);
        console.log("invamt", invamt);
        inve.invamt = invamt;


        var obj = new TE.IssueData("R")
        obj.companyUn = companyUn; // 公司統一編號 String 8 V
        obj.orgId = orgId; // 事業別代碼 String 5 V
        obj.orgUn = orgUn; // 事業別統一編號 String 8 V
        obj.type = "R"; // 類別 String 1 V    I:開立發票      R:重開發票
        // obj.saleIdentifier = +companyUncheckno; // 銷售單識別碼 String 100 V //2023-08-23 bugfix
        // obj.saleIdentifier = companyUn + companyUncheckno; // 銷售單識別碼 String 100 V  //bufix: 變數companyUncheckno不存在
        obj.saleIdentifier = companyUn + checkno + inve.invno; // 銷售單識別碼 String 100 V 
        obj.transactionNumber = checkno; // 銷售單交易編號 String 50 V
        obj.transactionDate = inve.invdate; // 銷售單交易日期 String 8 V
        obj.transactionTime = inve.time; // 銷售單交易時間 String 8 V
        obj.invoiceNumber = inve.invno; // 發票號碼 String 10 V
        // obj.checkNumber = inve.random // 隨機碼 String 4 V
        // obj.invoiceDate = inve.invdate.replace(/-/g, ""); // 發票日期 String 8 V
        // obj.invoiceTime = inve.time; //發票時間 String 8 V
        // obj.texclusiveAmount = inve.invamt //應稅發票總銷售額(未稅) String 20 V
        // obj.oexclusiveAmount = "0"; //免稅發票總銷售額 String 20 V
        // obj.zexclusiveAmount = "0"; // 零稅率發票總銷售額 String 20 V
        // obj.tax = "0"; // 發票稅額 String 20 V
        obj.total = inve.invamt; //銷售總金額 / 折讓總金額 / 發票總金額 String 20 V
        obj.donate = "N"; // 發票是否捐贈 String 1 V
        // obj.invoiceType = "07" //若Type為「I」、「R」、「G」則必填	"07：一般稅額計算之電子發票        
        obj.paperPrintMode = "1"; // 消費者發票或折讓列印之方式 String 1 V 1:POS
        obj.invoiceAlarmMode = "0"; //發票或折讓之通知方式 String 1 V
        obj.itemList = [] // 發票明細項目(Item List of eGUI) List < IssueItem > V

        var list = new TE.ItemList;
        list.saleIdentifier = companyUn + checkno + inve.invno; // 銷售單識別碼	String	100	V	V	必填	"當IssueData的type=I、G、R時，同IssueData saleIdentifier 當IssueData的type=A、H時，欲折讓之發票銷售單識別碼"
        list.serialNumber = "1"; // 	銷售項目序號/折讓項目序號	String	4	V	V	必填	"0001,0002,0003…    若Type為「A 」、「H」，需列出對應銷售項目序號"
        list.productCode = ""; // 收費代碼;產品編碼	String	30	V	V		
        list.productName = "餐飲費"; // 銷售品項/折讓品項	String	300	V	V	必填	
        list.qty = "1"; // 	銷售數量/折讓數量	String	20	V	V	必填	
        list.price = inve.invamt; // 單價(含稅)	String	20	V	V	必填	
        list.itemTotal = inve.invamt; // 	品項含稅銷售額/品項含稅折讓額	String	20	V	V	必填	
        list.taxType = "T"; // 銷稅稅別	String	1	V	V	必填	"T：應稅    O：免稅    Z：零稅率"
        obj.itemList.push(list);

        fits.writeLog("加密前的資料", JSON.stringify(obj));
        var encrypted = api.encrypt(JSON.stringify(obj), privateKey).update;

        var obj1 = {};
        obj1.acnt = acnt;
        obj1.acntp = acntp;
        obj1.issueData = encrypted;

        // console.log("step 3 公鑰加密:", publicKey);
        var encrypted = api.encrypt(JSON.stringify(obj1), publicKey).update;
        var output = {};
        output.v = encrypted;
        return output;
    },

    async invTerm(period) {
        var uuid = uuidv4();
        var encrypted = api.encrypt(uuid, privateKey);
        var event_verification = encrypted.update;
        var body = {};
        body.acnt = acnt;
        body.acntp = acntp;
        body.event_time = moment().format("YYYY-MM-DD HH:mm:ss");
        body.event_id = uuid;
        body.event_verification = event_verification;
        body.event_type = "apply.markserialinterval";
        body.event_encode = "N";
        body.meta_count = "1";
        var meta = [{
            "serialnumber": "0001",
            "companyun": companyUn,
            "orgid": orgId,
            "booktype": "API",
            "period": period,
            "numrange": numRange,
            "fullnumrange": "N"
        }]

        body.meta = meta;
        return body;
    },

}

function getCarrierType(carrierId) {
    if (carrierId.length == 8) {
        if (carrierId.substring(0, 1) == '/') {
            return "3J0002" //：手機條碼
        }
    }

    if (carrierId.length == 16) {
        return "CQ0001" //：自然人憑證
    }

    return "";
}

function isDonate(donationUnit) {
    if (donationUnit != "") { return "Y"; }

    return "N";
}

function getTaxType(value) {
    if (value == "NT") { return "O"; }

    return "T";
}

function getPaperPrintMode(inve) {

    if (inve.love != "") { return "0"; }

    if (getCarrierType(inve.carrier) != "") { return "0"; }

    return "1";
}