var fs = require('fs');
var middle = require("./basic-middle");
var bk35 = require('./lib-adodb.js');
var fits = require('./lib-fits');

fits.writeLog("初始化檢查..");

main();

async function main() {
    try {

        var inveDir = await fits.getSetting("BK3", "IP", "InvE_Dir");
        inveDir = fits.str(inveDir);

        if (inveDir == "") {
            await fits.saveSetting("BK3", "IP", "InvE_Dir", "D:\\INVE");
        }

        var dir = await middle.getDir();
        var file = await middle.getFiles();
        var ip = await fits.getSetting("BK3", "IP");
        var sys = await fits.getSetting("BK3", "SYS");
        var opdate = await bk35.getParam("OPDate");
        var head0 = await bk35.getParam("InvHead0");
        var head1 = await bk35.getParam("InvHead1");
        var head2 = await bk35.getParam("InvHead2");
        var head3 = await bk35.getParam("InvHead3");
        var bno = head1;

        fits.writeLog("IP", JSON.stringify(ip));

        var errors = [];

        if (sys.InvE == "") {
            errors.push("fits.InvE <> Y");
        }

        if (ip.InvE_Dir == "") {
            errors.push("電子發票資料夾未設定");
        }

        if (!fs.existsSync(dir.path)) {
            errors.push("電子發票資料夾不存在" + dir.path);
        }

        opdate = fits.replace(opdate, "/", "-");
        if (opdate != fits.today()) {
            errors.push("營業日與系統時間不符,營業日:" + opdate + ",系統時間:" + fits.today());
        }

        if (fits.str(bno) == "" || bno.length != 8) {
            errors.push("統編設定錯誤(InvHead1)" + bno);
        }

        if (fs.existsSync(file.invData)) {
            errors.push("檔案已存在" + file.invData);
        }

        if (fs.existsSync(file.invLast)) {
            errors.push("檔案已存在" + file.invLast);
        }

        if (fs.existsSync(file.invNOBE)) {
            errors.push("檔案已存在" + file.invNOBE);
        }

        if (fs.existsSync(file.invNOBENext)) {
            errors.push("檔案已存在" + file.invNOBENext);
        }

        if (fits.str(ip.ApplyNumber) != "") {
            errors.push("reg.ApplyNumber 不是空值");
        }

        if (fits.str(ip.BNO) != "") {
            errors.push("reg.BNO 不是空值" + ip.BNO);
        }

        if (fits.str(ip.InvMontho) != "") {
            errors.push("reg.InvMonth 不是空值");
        }

        if (fits.str(ip.InvNoBE_Next) != "") {
            errors.push("reg.InvNoBE_Next 不是空值");
        }

        if (fits.str(ip.InvYear) != "") {
            errors.push("reg.InvYear 不是空值");
        }

        if (fits.str(ip.LastSend) != "") {
            errors.push("reg.LastSend 不是空值");
        }

        if (fits.str(ip.MaxInvNo) != "") {
            errors.push("reg.MaxInvNo 不是空值");
        }

        if (fits.str(ip.NextBatch) != "") {
            errors.push("reg.NextBatch 不是空值");
        }

        if (fits.str(ip.QRCode) != "") {
            errors.push("reg.QRCode 不是空值");
        }

        if (errors.length > 0) {
            return fits.writeLog("無法初始化:" + JSON.stringify(errors));
        }


        fits.writeLog("初始化->開始");

        var line = "";
        line = bno + ",";
        line += sys.POSID + ",";
        line += "Tradeven" + ",";
        line += head0 + ",";
        line += head1 + ",";
        line += head2 + ",";
        line += head3;


        await fits.saveSetting("BK3", "SYS", "InvE", "Y");
        await fits.saveSetting("BK3", "IP", "BNO", bno);
        await fits.saveSetting("BK3", "IP", "QRCode", "Tradeven");
        await middle.writeInvData(line);

        fits.writeLog("初始化->完成");

    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}