var fs = require('fs');
var fsp = fs.promises;
// var reg = require('./_lib-registry.js');
var iconv = require('iconv-lite');
var InvE = require('./class-InvE.js'); //電子發票檔：開立/作廢/作廢取消重開
var fits = require('./lib-fits');


module.exports = {
    async getDir() {
        try {
            var dir = {};
            var inveDir = await fits.getSetting("BK3", "IP", "InvE_Dir");
            inveDir = str(inveDir);

            dir.path = inveDir;
            dir.add = dir.path + "\\ADD";
            dir.bak = dir.path + "\\BAK";
            dir.err = dir.path + "\\ERR";
            dir.unvoid = dir.path + "\\Unvoid";
            dir.void = dir.path + "\\Void";
            dir.m1 = dir.path + "\\M01";
            dir.m2 = dir.path + "\\M02";
            dir.m3 = dir.path + "\\M03";
            dir.m4 = dir.path + "\\M04";
            dir.m5 = dir.path + "\\M05";
            dir.m6 = dir.path + "\\M06";
            dir.m7 = dir.path + "\\M07";
            dir.m8 = dir.path + "\\M08";
            dir.m9 = dir.path + "\\M09";
            dir.m10 = dir.path + "\\M10";
            dir.m11 = dir.path + "\\M11";
            dir.m12 = dir.path + "\\M12";
            dir.add_r = dir.path + "\\ADDR";
            if (!fs.existsSync(dir.path)) { fs.mkdirSync(dir.path); }
            if (!fs.existsSync(dir.add)) { fs.mkdirSync(dir.add); }
            if (!fs.existsSync(dir.bak)) { fs.mkdirSync(dir.bak); }
            if (!fs.existsSync(dir.err)) { fs.mkdirSync(dir.err); }
            if (!fs.existsSync(dir.unvoid)) { fs.mkdirSync(dir.unvoid); }
            if (!fs.existsSync(dir.void)) { fs.mkdirSync(dir.void); }
            if (!fs.existsSync(dir.m1)) { fs.mkdirSync(dir.m1); }
            if (!fs.existsSync(dir.m2)) { fs.mkdirSync(dir.m2); }
            if (!fs.existsSync(dir.m3)) { fs.mkdirSync(dir.m3); }
            if (!fs.existsSync(dir.m4)) { fs.mkdirSync(dir.m4); }
            if (!fs.existsSync(dir.m5)) { fs.mkdirSync(dir.m5); }
            if (!fs.existsSync(dir.m6)) { fs.mkdirSync(dir.m6); }
            if (!fs.existsSync(dir.m7)) { fs.mkdirSync(dir.m7); }
            if (!fs.existsSync(dir.m8)) { fs.mkdirSync(dir.m8); }
            if (!fs.existsSync(dir.m9)) { fs.mkdirSync(dir.m9); }
            if (!fs.existsSync(dir.m10)) { fs.mkdirSync(dir.m10); }
            if (!fs.existsSync(dir.m11)) { fs.mkdirSync(dir.m11); }
            if (!fs.existsSync(dir.m12)) { fs.mkdirSync(dir.m12); }
            return dir;
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
        }

    },


    async getFiles() {
        try {
            var files = {};
            var inveDir = await fits.getSetting("BK3", "IP", "InvE_Dir");
            inveDir = str(inveDir);

            var dir = inveDir;
            files.invData = dir + "\\invData.txt";
            files.invLast = dir + "\\invLast.txt";
            files.invNOBE = dir + "\\invNOBE.txt";
            files.invNOBENext = dir + "\\invNOBENext.txt";
            files.invNextTerm = dir + "\\invNextTerm.txt";
            return files;
        } catch (error) {
            fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
        }
    },


    async getMonthDir(month) {
        var path = await fits.getSetting("BK3", "IP", "InvE_Dir");
        return path + "\\M" + month;
    },



    async writeInvData(data) {
        var file = await this.getFiles();
        var b5_data = iconv.encode(data, 'big5');
        return fsp.writeFile(file.invData, b5_data);
    },


    async writeInvLast(data) {
        var file = await this.getFiles();
        var b5_data = iconv.encode(data, 'big5');
        return fsp.writeFile(file.invLast, b5_data);
    },


    async writeInvNOBE(data) {
        var file = await this.getFiles();
        var b5_data = iconv.encode(data, 'big5');
        return fsp.writeFile(file.invNOBE, b5_data);
    },


    async writeIinvNOBENext(data) {
        var file = await this.getFiles();
        var b5_data = iconv.encode(data, 'big5');
        return fsp.writeFile(file.invNOBENext, b5_data);
    },


    async writeInvNextTerm(data) {
        var file = await this.getFiles();
        var b5_data = iconv.encode(data, 'big5');
        return fsp.writeFile(file.invNextTerm, b5_data);
    },

}

function str(s) {
    if (s == undefined) { return "" }
    return s.trim();
}