var fs = require("fs");
const fsp = fs.promises;
var iconv = require('iconv-lite');
var InvE = require('./class-InvE.js'); //電子發票檔：開立/作廢/作廢取消重開
var TE = require('./class-Tradeven.js');
var api = require('./api-Tradeven.js');
// var dir = {};
var path = require('path');
var middle = require('./basic-middle.js');
var parse = require('./parse-tradeven.js');
var fits = require('./lib-fits.js');

var timer1 = null;
var timer2 = null;
var timer3 = null;

main();

async function main() {

    var dir = await middle.getDir();

    timer1_start(dir);

    timer2_start(dir);

    timer3_start(dir);



}



function timer1_start(dir) {
    timer1 = setInterval(scanAdd, 1000 * 10, dir);
    fits.writeLog("開始U1");
};

function timer1_stop() {
    timer1 = clearInterval(timer1);
    fits.writeLog("暫停U1");
};

function timer2_start(dir) {
    timer2 = setInterval(scanVoid, 1000 * 30, dir);
    fits.writeLog("開始U2");
};

function timer2_stop() {
    timer2 = clearInterval(timer2);
    fits.writeLog("暫停U2");
};

function timer3_start(dir) {
    timer3 = setInterval(scanUnvoid, 1000 * 30, dir);
    fits.writeLog("開始U3");
};

function timer3_stop() {
    timer3 = clearInterval(timer3);
    fits.writeLog("暫停U3");
};




async function scanAdd(dir) {

    try {
        var list = await fsp.readdir(dir.add);
        list = list.filter((f) => path.extname(f).toLowerCase() == ".txt");

        if (list.length == 0) { return; }

        timer1_stop();
        list.sort();

        for (let i = 0; i < list.length; i++) {
            var element = list[i];
            var file = dir.add + "\\" + element;
            console.log("i", i);
            await uploadAdd(file, dir);
        }

        timer1_start(dir);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}



async function scanVoid(dir) {
    try {
        let list_add = await fsp.readdir(dir.add);
        if (list_add.length > 0) return; //如果add尚有在處理的資料，等上傳完再做

        var list = await fsp.readdir(dir.void);
        if (list.length == 0) { return; }

        timer2_stop();
        list.sort();

        for (let i = 0; i < list.length; i++) {
            var element = list[i];
            var file = dir.void + "\\" + element;
            console.log("i", i);
            await uploadVoid(file, dir);
        }

        timer2_start(dir);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}



async function scanUnvoid(dir) {
    try {

        let list_add = await fsp.readdir(dir.add);
        if (list_add.length > 0) return; //如果add尚有在處理的資料，等上傳完再做

        var list = await fsp.readdir(dir.unvoid);
        list = list.filter(r => path.extname(r) == ".txt");
        // console.log("unvoid", list);

        if (list.length == 0) { return; }
        // console.log(path.basename(list[0]));
        // return;
        timer3_stop();
        list.sort();

        for (let i = 0; i < list.length; i++) {
            var element = list[i];
            var file = dir.unvoid + "\\" + element;
            console.log("i", i);
            await uploadUnvoid(file, dir);
        }

        timer3_start(dir);

    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}



async function uploadAdd(file, dir) {
    try {

        var inve = await parse_inve_add(file);
        fits.writeLog("上傳檔案", file, JSON.stringify(inve));


        var body = parse.add(inve);
        fits.writeLog("送出去的資料", JSON.stringify(body));


        var res = await api.add_invoice(body)
        fits.writeLog("收到的資料", JSON.stringify(res));

        var decrypted = "";
        if (res.Success == "Y" || res.Success == "N") {
            decrypted = api.decrypt(res.Message);
            fits.writeLog("收到的資料->解密", JSON.stringify(decrypted));
        }

        if (res.Success == "Y") {
            var bakDir = dir.path + "\\M" + inve.month;
            await fsp.rename(file, bakDir + "\\" + path.basename(file));
            await fits.saveSetting("BK3", "IP", "LastSend", fits.now() + path.parse(file).name);
            fits.writeLog("上傳完成", file);
        } else {
            await fsp.rename(file, dir.err + "\\" + path.basename(file))
            fits.writeLog("上傳錯誤->移至err目錄", dir.err + "\\" + path.basename(file));
            var errFile = path.join(dir.err, path.basename(file) + ".res");
            var line = "收到的資料：" + JSON.stringify(res) + fits.crlf;
            line += "收到的資料解密：" + JSON.stringify(decrypted);
            await fsp.writeFile(errFile, line);
        }


    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }
}

async function uploadVoid(file, dir) {

    try {

        var inve = await parse_inve_void(file);
        fits.writeLog("上傳檔案", file, JSON.stringify(inve));


        var body = await parse.void(inve);
        fits.writeLog("送出去的資料", JSON.stringify(body));


        var res = await api.void_invoice(body)
        fits.writeLog("收到的資料", JSON.stringify(res));

        if (res.Success == "Y" || res.Success == "N") {
            var decrypted = api.decrypt(res.Message);
            fits.writeLog("收到的資料->解密", JSON.stringify(decrypted));
        }

        if (res.Success == "Y") {
            var bakDir = dir.path + "\\M" + inve.month;
            await fsp.rename(file, bakDir + "\\" + path.basename(file) + "D");
            fits.writeLog("上傳完成", file);

            //作廢發票要複製原開立發票add檔案，當作廢還原時要用;
            var srcFile = path.join(bakDir, path.basename(file));
            var destFile = path.join(dir.unvoid, path.parse(file).name + ".addr");
            fits.writeLog("add->unvoid", srcFile, destFile);
            if (fs.existsSync(srcFile)) {
                await fsp.copyFile(srcFile, destFile);
                fits.writeLog("備份作廢還原add檔", srcFile, destFile);
            }
        } else {
            await fsp.rename(file, dir.err + "\\" + path.basename(file) + "D");
            fits.writeLog("上傳錯誤->移至err目錄", dir.err + "\\" + path.basename(file) + "D");
            var errFile = path.join(dir.err, path.basename(file) + "D" + ".res");
            var line = "收到的資料：" + JSON.stringify(res) + fits.crlf;
            line += "收到的資料解密：" + JSON.stringify(decrypted);
            await fsp.writeFile(errFile, line);
        }


    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}



async function uploadUnvoid(file, dir) {

    try {

        //step1 上傳發票作廢註銷檔unvoid
        var inve = await parse_inve_unvoid(file);
        fits.writeLog("上傳檔案", file, JSON.stringify(inve));

        var body = await parse.void_c(inve);
        fits.writeLog("送出去的資料", JSON.stringify(body));

        var res = await api.void_invoice(body); //註銷發票
        fits.writeLog("收到的資料", JSON.stringify(res));
        // {\"saleIdentifier\":\"221127-005\",\"voidStatus\":\"N\",\"failReason\":\"B_D02^發票狀態非開立，不可註銷/作廢\",\"type\":\"C\",\"invoiceNumber\":\"GE05100017\",\"allowa"

        if (res.Success == "Y" || res.Success == "N") {
            var decrypted = api.decrypt(res.Message);
            fits.writeLog("收到的資料->解密", JSON.stringify(decrypted));
        }

        if (res.Success == "Y") {
            var bakDir = dir.path + "\\M" + inve.month;
            await fsp.rename(file, bakDir + "\\" + path.basename(file) + ".unvoid");
            fits.writeLog("上傳註銷完成", file);
        } else {
            await fsp.rename(file, dir.err + "\\" + path.basename(file))
            fits.writeLog("上傳錯誤->移至err目錄", dir.err + "\\" + path.basename(file) + ".unvoid");
            var errFile = path.join(dir.err, path.basename(file) + ".unvoid" + ".res");
            var line = "收到的資料：" + JSON.stringify(res) + fits.crlf;
            line += "收到的資料解密：" + JSON.stringify(decrypted);
            await fsp.writeFile(errFile, line);
        }


        //step2 上傳發票開立檔add
        var dirName = path.dirname(file);
        var fileName = path.parse(file).name + ".addr";
        var addFile = path.join(dirName, fileName);
        fits.writeLog("addFile", addFile);
        // return;
        var inve = await parse_inve_add(addFile);
        fits.writeLog("上傳檔案", addFile, JSON.stringify(inve));

        var body = await parse.add_r(inve);
        fits.writeLog("送出去的資料", JSON.stringify(body));

        var res = await api.add_invoice(body)
        fits.writeLog("收到的資料", JSON.stringify(res));

        var decrypted = "";
        if (res.Success == "Y" || res.Success == "N") {
            decrypted = api.decrypt(res.Message);
            fits.writeLog("收到的資料->解密", JSON.stringify(decrypted));
        }

        if (res.Success == "Y") {
            var bakDir = dir.path + "\\M" + inve.month;
            await fsp.rename(addFile, bakDir + "\\" + path.basename(addFile));
            // await fits.saveSetting("BK3", "IP", "LastSend", fits.now() + path.parse(file).name);
            fits.writeLog("上傳完成", addFile);
        } else {
            await fsp.rename(addFile, dir.err + "\\" + path.basename(addFile))
            fits.writeLog("上傳錯誤->移至err目錄", dir.err + "\\" + path.basename(addFile));
            var errFile = path.join(dir.err, path.basename(addFile) + ".res");
            var line = "收到的資料：" + JSON.stringify(res) + fits.crlf;
            line += "收到的資料解密：" + JSON.stringify(decrypted);
            await fsp.writeFile(errFile, line);
        }


    } catch (error) {
        fits.writeErr({ "檔案": __filename, "程序": arguments.callee.name, "錯誤": error.toString() });
    }

}





async function parse_inve_add(file) {
    var value = await fsp.readFile(file);
    var data = iconv.decode(value, 'big5');
    var invno = path.parse(file).name;
    return new InvE.Add(invno, data);
}

async function parse_inve_void(file) {
    var value = await fsp.readFile(file);
    var data = iconv.decode(value, 'big5');
    var invno = path.parse(file).name;
    return new InvE.Void(invno, data);
}

function parse_inve_unvoid(file) {
    return new Promise((resolve, reject) => {
        fsp.readFile(file)
            .then((value) => {
                var data = iconv.decode(value, 'big5');
                // var invno = path.parse(file).name;
                var obj = new InvE.Unvoid(data);
                resolve(obj);
            })
            .catch((err) => {
                reject(err);
            })
    })
}