// const version = 'R.2022-12-02';
var fs = require('fs');
var fsp = fs.promises;
var fits = require('./lib-fits');
var path = require('path');
var moment = require('moment');


var dir = {};
dir.patch = "patch";
dir.backup = "舊版備份";
if (!fs.existsSync(dir.patch)) { fs.mkdirSync(dir.patch); }
if (!fs.existsSync(dir.backup)) { fs.mkdirSync(dir.backup); }

var args = process.argv;
var appName = args[2];

main(appName);


async function main(name) {
    try {
        await backup();
        await update(name);
    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}

async function backup() {
    try {
        var array = __dirname.split(path.sep);
        var appName = array[array.length - 1];
        var now = moment().format("_YYYYMMDD-HHmmss");
        var zipFile = path.join(dir.backup, appName + now + ".7z");
        await fits.zip(zipFile, "*.js", "node_modules", "vuejs");
        fits.writeLog("更新前備份", zipFile);
    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }
}


async function update(appname) {
    try {
        var dir = "patch";

        if (!fs.existsSync(dir)) { fs.mkdirSync(dir); }

        var remoteFile = "/node19/" + appname + ".7z"
        var now = moment().format("_YYYYMMDD-HHmmss");
        var zipfile = path.join(__dirname, dir, path.basename(remoteFile));
        var bakfile = path.join(__dirname, dir, path.parse(remoteFile).name + now + path.extname(remoteFile));
        if (fs.existsSync(zipfile)) { await fsp.unlink(zipfile); }
        fits.writeLog("開始下載", remoteFile);
        await fits.ftpGet(remoteFile, dir);
        fsp.copyFile(zipfile, bakfile);
        fits.writeLog("下載完成", zipfile);
        // console.log(res);

        console.log("zipfile", zipfile);
        var res = await fits.unzip(zipfile);
        fits.writeLog("解壓完成", zipfile);
        console.log("res", res);

        var pkg = require("./package.json");
        fits.showMsg("更新完成", pkg.name, pkg.version);


    } catch (error) {
        fits.writeErr({ 檔案: __filename, 程序: arguments.callee.name, 錯誤: error.toString() });
    }

}